PROGRAM PRG_Transportband_1
  VAR
    MOT1RUN AT %QX0.0 : BOOL;
    MOT1DIR AT %QX0.1 : BOOL;
    BLINKLED AT %QX0.7 : BOOL;
    START AT %IX0.0 : BOOL;
    SENSORLINKS AT %IX0.1 : BOOL;
    SENSORRECHTS AT %IX0.2 : BOOL;
  END_VAR
  VAR
    STATE : INT := 0;
    TMR_MOTOR : TON;
    TMR_BLINK : TON;
    TMR_READY : BOOL := FALSE;
    TMR_BLINK_ET : TIME;
    TMR_MOTOR_ET : TIME;
  END_VAR

  (* Programm Transportband *)
  (* LED blinken lassen *)
    TMR_BLINK(IN:= NOT TMR_BLINK.Q,PT:=T#200ms,Q=>TMR_READY,ET=>TMR_BLINK_ET);
    
    IF TMR_READY THEN 
      BLINKLED:=NOT BLINKLED;
    END_IF;

  (* State Machine fuer das Transportband *)
  (* Wenn der START Taster und der Kontakt SensorLinks *)
  (* betaetigt werden startet das Transportband nach rechts *)
  (* wenn die rechte Position erreicht ist stoppt das Band *)
  (* und wartet 5 Sekunden *)
  (* Dann faehrt es wieder nach links bis SensorLinks betätigt wird *) 
    CASE STATE OF
         (* Startbedingung  *) 
         0: IF (START AND SENSORLINKS) THEN
          STATE:=10;
        END_IF;
      (* Rechte Position erreicht *)
      10: IF SENSORRECHTS THEN
          STATE:=20;
         END_IF;
      (* 5 Sekunden warten dann nach links *)
      20:TMR_MOTOR(IN:= NOT TMR_MOTOR.Q,PT:=T#5S,ET=>TMR_MOTOR_ET);
          IF TMR_MOTOR.Q THEN
            STATE:=30;
          END_IF;
      (* Motor wieder nach links *)
      30: IF SENSORLINKS THEN
          STATE:=0;
          END_IF;
    END_CASE;  

  (* Schalten der Motor Leitungen *)
      
    CASE STATE OF
      0:MOT1RUN:=FALSE;
      10:MOT1RUN:=TRUE; MOT1DIR:=TRUE;
      20:MOT1RUN:=FALSE;
      30:MOT1RUN:=TRUE; MOT1DIR:=FALSE;
    END_CASE; 
    
END_PROGRAM


CONFIGURATION Config0

  RESOURCE Res0 ON PLC
    TASK TaskMain(INTERVAL := T#10ms,PRIORITY := 0);
    PROGRAM instance0 WITH TaskMain : PRG_Transportband_1;
  END_RESOURCE
END_CONFIGURATION
